<?php
define('PAWN_VERSION', '0.0.2');

spl_autoload_register(function($path)
{
	$path = implode('/', explode('\\', strtolower($path))).'.php';
	
	require file_exists(ROOT.$path)?ROOT.$path:FW.$path;
});

abstract class Pawn
{
	// Initialize
	public static function init($env='production')
	{
		ob_start();
		
		# Framework
		define('FW', __dir__.'/');
		define('ROOT', dirname($_SERVER['SCRIPT_FILENAME']).'/');
		define('ROUTE', isset($_GET['p'])?$_GET['p']:'/');
		define('PAWN_ENV', $env);
		
		ini_set('auto_detect_line_endings', true);
		
		if(PAWN_ENV === 'production')
		{
			error_reporting(0);
		} else
		{
			error_reporting(E_ALL);
		}
		
		# Constants
		define('MT', microtime(true));
		define('WEB', substr($_SERVER['SCRIPT_NAME'], 0, -10));
		
		# mod_rewrite
		if(isset($_SERVER['MOD_REWRITE']) || (function_exists('apache_get_modules') && in_array('mod_rewrite', apache_get_modules())))
		{
			define('MOD_REWRITE', true);
		}
		
		# Autoload
		global $autoload;
		
		$autoload = self::config('config/autoload.yml', function()
		{
			$config = Pawn::config('config/autoload.yml');
			
			$config['Lang'] = array_merge(array('global'), isset($config['Lang'])?$config['Lang']:array());
			
			Pawn::merge($config, array
			(
				'Session'	=>	array
				(
					'user'	=>	'User'
				)
			));
			
			return \lib\YAML::fromArray($config);
		});
		
		# Database
		$db = self::config('db', function()
		{
			$app = Pawn::config('config/app.yml');
			
			Pawn::setting('title', $app['title']);
			Pawn::setting('company', 'Summoner');
			Pawn::setting('locale', 'en');
			Pawn::setting('timezone', date_default_timezone_get());
			Pawn::setting('date_format', 'M j, Y');
			Pawn::setting('template', 'default');
			
			return controller\Pawn::setup();
		}, false);
		
		define('SECRET', $db['secret']);
		define('PREFIX', $db['prefix']);
		
		# Configuration
		$config = \lib\db::init($db['driver'], $db['host'], $db['username'], $db['password'], $db['database']);
		
		date_default_timezone_set($config['timezone']);
		
		foreach($config as $key=>$value)
		{
			self::setting($key, $value);
		}
		
		if(isset($config['mod_rewrite']))
		{
			define('MOD_REWRITE', true);
		}
		
		# Update
		$app = self::config('config/app.yml');
		
		if(PAWN_ENV == 'development' || version_compare($config['version'], $app['version'], '<'))
		{
			define('UPDATE', $config['version']);
			
			// Cache
			$cache_files = opendir(ROOT.'cache/');
			
			while(($cache_file = readdir($cache_files)) !== false)
			{
				if($cache_file == 'db.php' || $cache_file == 'statistics.php' || $cache_file == '.' || $cache_file == '..')
				{
					continue;
				}
				
				unlink(ROOT.'cache/'.$cache_file);
			}
			
			// Database
			$paths = array(ROOT.'model/', FW.'model/');
			
			foreach($paths as $path)
			{
				$directory = opendir($path);
				
				while(($file = readdir($directory)) !== false)
				{
					if($file == '.' || $file == '..') continue;
					
					call_user_func('model\\'.substr($file, 0, -4).'::migrate');
				}
			}
			
			\lib\db::execute('UPDATE `'.PREFIX.'config` SET `value`="'.$app['version'].'" WHERE `key`="version"');
		}
		
		# Super-user
		if(!model\User::get('WHERE level=?', 5)->fetch())
		{
			controller\Pawn::super_user();
		}
		
		# Session
		if(isset($autoload['Session']))
		{
			foreach($autoload['Session'] as $key=>$value)
			{
				if(!is_array($value))
				{
					$value = array($value, 'session');
				}
				
				$autoload['Session'][$key] = call_user_func(array('model\\'.$value[0], $value[1]));
			}
		}
		
		# Statistics
		/*
		if($statistics = @fopen(ROOT.'cache/statistics.php', 'a'))
		{
			fwrite($statistics, time().' '.$_SERVER['REMOTE_ADDR'].' '.ROUTE."\n");
			
			fclose($statistics);
		}
		*/
		
		# Route
		self::$routing = self::config('config/routing.yml', function($file)
		{
			$pawn = array
			(
				'settings'			=>	'/settings',
				'advertisements'	=>	'/advertisements',
				//'log_out'			=>	'/exit',
				'add'				=>	'/add/{model}',
				'action'			=>	'/{action}/{model}',
				'edit'				=>	'/edit/{model}/{instances}',
				'bulk'				=>	'/bulk/{action}/{model}',
				'rows'				=>	'/rows/{model}/{page}/{sort}/{asc}',
				'model'				=>	array
				(
					'',
					'/{name}'
				)
			);
			
			$routing = lib\YAML::parse($file);
			
			foreach($pawn as $key=>$value)
			{
				if(is_array($value))
				{
					foreach($value as $subkey=>$subvalue)
					{
						$pawn[$key][$subkey] = $routing['Pawn'].$subvalue;
					}
				} else
				{
					$pawn[$key] = $routing['Pawn'].$value;
				}
			}
			
			$routing['Pawn'] = $pawn;
			
			$cache = "<?php\nreturn array (";
			
			foreach($routing as $controller=>$actions)
			{
				$cache .= "\n  '$controller' => \n  array (";
				
				foreach($actions as $action=>$routes)
				{
					$cache .= "\n    '$action' => \n    array (";
					
					$routes = (array) $routes;
					
					foreach($routes as $key=>$route)
					{
						$cache .= "\n      '$route' => '#^".preg_replace('/\{([a-z]+)\}/', '(?P<$1>([^/]+))', strtr($route, array('+'=>'\+'))).((substr($route, -1) == '/')?'':'/?')."$#U',";
					}
					
					$cache .= "\n    ),";
				}
				
				$cache .= "\n  ),";
			}
			
			$cache .= "\n);";
			
			return $cache;
		});
		
		foreach(self::$routing as $controller=>$actions)
		{
			foreach($actions as $action=>$routes)
			{
				foreach($routes as $route=>$pattern)
				{
					if(preg_match($pattern, ROUTE, $raw))
					{
						$n = (count($raw) - 1)/3;
						
						$args = array();
						
						if($n)
						{
							for($i=1; $i<=$n; $i++)
							{
								$args[] = $raw[$i*2];
							}
						}
						
						$autoload['Session'] = array_merge(isset($autoload['Session'])?$autoload['Session']:array(), array
						(
							'__action__'		=>	$action,
							'__controller__'	=>	$controller
						));
						
						$bridge = self::Controller($controller);
						
						$response = call_user_func_array(array($bridge, $action), $args);
						
						exit;
					}
				}
			}
		}
		
		$controller = new Pawn\Controller;
		
		return $controller->not_found();
	}
	
	// Configuration
	public static function config($file, $function=array('lib\\YAML', 'cache'), $strict=true)
	{
		return include self::cache($file, $function, $strict);
	}
	
	// Settings
	private static $settings = array();
	
	public static function setting($key, $value=null)
	{
		if($value !== null)
		{
			self::$settings[$key] = $value;
		}
		
		return isset(self::$settings[$key])?self::$settings[$key]:null;
	}
	
	public static function settings()
	{
		return self::$settings;
	}
	
	// Caching
	public static function cache($file, $function, $strict=true, $suffix='.php')
	{
		$name = ROOT.'cache/'.str_replace('/', '_', $file).$suffix;
		
		if(!file_exists($name) || (PAWN_ENV == 'development' && $strict))
		{
			if(file_exists(ROOT.$file))
			{
				$file = ROOT.$file;
			} elseif(file_exists(FW.$file))
			{
				$file = FW.$file;
			}
			
			if(@file_put_contents($name, call_user_func($function, $file)) === false)
			{
				throw new Pawn\Exception('Configuration', 'The <b>/cache</b> folder is not writable. Try chmodding it to 775 or 777 and refresh the page to see if the error disappears.', false, false);
			} elseif(file_exists($file))
			{
				touch($name, isset($time)?$time:filemtime($file));
			}
		}
		
		return $name;
	}
	
	// Routing
	private static $routing;
	
	public static function path($controller, $action, $args=array())
	{
		if(!isset(self::$routing[$controller]) || !isset(self::$routing[$controller][$action])) return WEB;
		
		$paths = array_keys(self::$routing[$controller][$action]);
		
		foreach($paths as $path)
		{
			foreach($args as $key=>$value)
			{
				if(strpos($path, '{'.$key.'}') === false)
				{
					continue 2;
				} else
				{
					$path = str_replace('{'.$key.'}', $value, $path);
				}
			}
			
			return defined('MOD_REWRITE')?WEB.$path:WEB.'/index.php?p='.$path;
		}
		
		return WEB;
	}
	
	public static function http_path($controller=false, $action='index', $args=array())
	{
		if($controller)
		{
			return 'http://'.$_SERVER['HTTP_HOST'].self::path($controller, $action, $args);
		}
		
		return 'http://'.$_SERVER['HTTP_HOST'].WEB;
	}
	
	// Helper
	public static function helper($file)
	{
		$path = 'helper/'.$file.'.php';
		
		return file_exists(ROOT.$path)?ROOT.$path:FW.$path;
	}
	
	// Date format
	public static function get_date($time=null)
	{
		if($time === null)
		{
			$time = time();
		}
		
		return date(self::setting('date_format'), $time);
	}
	
	// Time ago
	public static function time_ago($ts)
	{
		\lib\Lang::load('time_ago');
		
		$seconds = time() - $ts;
		
		$periods = array
		(
			'years'		=>	31556926,
			'months'	=>	2629743,
			'weeks'		=>	604800,
			'days'		=>	86400,
			'hours'		=>	3600,
			'minutes'	=>	60,
			'now'		=>	0
		);
		
		foreach($periods as $period=>$length)
		{
			if($seconds >= $length)
			{
				return \lib\Lang::get('time_ago', $period, $length?floor($seconds/$length):$seconds);
			}
		}
	}
	
	// Merge
	public static function merge(&$container, $load)
	{	
		foreach($load as $key=>$value)
		{
			if(!is_array($value))
			{
				$container[$key] = $value;
			} else
			{
				if(!isset($container[$key]))
				{
					$container[$key] = $value;
				} elseif(!is_array($container[$key]))
				{
					$container[$key] = $value;
				} else
				{
					self::merge($container[$key], $value);
				}
			}
		}
	}
	
	// Remote file contents
	public static function remote_contents($url)
	{
		if((bool) ini_get('allow_url_fopen'))
		{
			return file_get_contents($url);
		}
		
		$ch = curl_init();
		
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		
		$contents = curl_exec($ch);
		
		curl_close($ch);
		
		return $contents;
	}
	
	// In Bytes
	public static function inBytes($size)
	{
		$replace = array
		(
			'k'	=>	1024,
			'M'	=>	1024*1024,
			'G'	=>	1024*1024*1024
		);
		
		foreach($replace as $key=>$value)
		{
			$size = str_replace($key, '*'.$value, $size);
		}
		
		return eval('return '.str_replace('B', '', $size).';');
	}
	
	// Controller
	public static function Controller($name, $args=array())
	{
		global $autoload;
		
		$classname = '\\controller\\'.$name;
		
		$controller = new $classname;
		
		if(isset($autoload['Session']))
		{
			foreach($autoload['Session'] as $key=>$value)
			{
				$controller->$key = $value;
			}
		}
		
		if(method_exists($controller, '_construct'))
		{
			call_user_func_array(array($controller, '_construct'), (array) $args);
		}
		
		return $controller;
	}
	
	// Send mail
	public static function send_mail($email, $subject, $message)
	{
		return @mail($email, $subject, $message, "From: admin@".$_SERVER['HTTP_HOST']."\nX-Mailer: PHP/".phpversion());
	}
}